$(document).ready(async function () {

  $('#tutorial').on('click', function () {
    $(document).ready(async function () {
      const driver = new Driver({
        doneBtnText: 'Sair',
        closeBtnText: 'Fechar',
        nextBtnText: 'Próximo',
        prevBtnText: 'Anterior',
        allowClose: false
      });
      driver.defineSteps([{
        element: '#btnFiltros',
        popover: {
          title: 'Botão Filtros',
          description: 'Clique aqui para abrir os filtros e realizar uma consulta.',
          position: 'right'
        }
      },
      {
        element: '#btnImprimir',
        popover: {
          title: 'Botão Imprimir',
          description: 'Clique aqui para imprimir um relatório.',
          position: 'right'
        }
      },
      {
        element: '#divTabelaVendas',
        popover: {
          title: 'Tabela Receber',
          description: 'Aqui, após clicar em consultar ficam os dados das duplicatas filtradas.',
          position: 'bottom'
        }
      }
      ]);
      driver.start();
    });
  });

  $('#btnFiltros').on('click', async function () {
    $('#modal-filtros').modal('show');
    $('#txtBordero').val('');
  });

  $('#btnBordero').pesquisa_serverside(['#txtBordero'], ['RECEBER.BORDERO'], ['ENTIDADE.NOME'], `{
    "tabela":"RECEBER", 
    "camposSelect":["RECEBER.BORDERO","RECEBER.NUMERO", "RECEBER.CODCLI", "ENTIDADE.NOME", "RECEBER.LANCAMENTO", "RECEBER.DT_EMISSAO", "RECEBER.DT_VENCTO"], 
    "leftJoin":[{
      "tabela": "ENTIDADE", "condicao": "RECEBER.CODCLI = ENTIDADE.CODCLI"
    }],
    "where": null,
    "orderBy": ["RECEBER.BORDERO"]}`,
    'Pesquisa Bordero');

  $('#btnLimpaBordero').on('click', function () {
    $('#txtBordero').val('');
  });

  $('#btnLimparFiltros').on('click', async function () {
    $('#txtBordero').val('');
  });

  // $('#btnSelecionarEmpresas').on('click', function () {
  //   carregaEmpresasDisponiveis();
  // });

  async function retornaFiltros() {
    const txtBordero = $("#txtBordero");
    const valor = txtBordero.val();
    const novoValor = valor.indexOf("[") === -1 ? "[" + valor + "]" : valor;
    txtBordero.val(novoValor);

    const sBordero = pegaChave("#txtBordero");
    const retorno = `BORDERO=${sBordero}`
    return retorno;
  }

  $('#btnConsultar').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        let dataSetCols = [];

        const url = '/sisplan/impressao/v1/consultarelbordero?';
        const filtros = await retornaFiltros();
        const response = await requisicao('GET', url, filtros, null);
        // $('#txtBordero').val('');

        if (!response) {
          return;
        }

        const jsonStr = await response.json();

        if (jsonStr.length == 0) {
          msgAlerta('Nenhum registro encontrado!');
          $(`#tabelaBordero`).DataTable().clear().draw(false);
          return;
        }

        if (response.status != 200) {
          console.error(jsonStr.mensagem);
          return;
        }

        let keys = Object.keys(jsonStr[0]);

        keys.forEach(k => {
          dataSetCols.push({
            'title': k,
            'data': k
          });
        });

        $('#tabelaBordero').DataTable({
          destroy: true,
          colReorder: true,
          filter: false,
          autoWidth: true,
          "data": jsonStr,
          "columns": dataSetCols,
          "columnDefs": [{
            "type": 'date-br',
            "targets": [5, 6],
            "render": function (data) {
              if (data != undefined) {
                x = data.slice(0, 10).split('-');
                return `${x[2]}/${x[1]}/${x[0]}`;
              } else {
                return ''
              }
            }
          },
          {
            "render": function (data) {
              return parseFloat(data).toLocaleString("pt-BR", {
                minimumFractionDigits: 2,
                maximumFractionDigits: 2,
              });
            },
            "targets": 2,
            "className": 'pr-4 text-right'
          },
          ],
        });

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
      $('#modal-filtros').modal('hide');
    }
  });

  retornaHintRelatorio('btnImprimir','RelBordero')

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        const url = `/sisplan/impressao/v1/imprimirrelbordero?`;
        const filtros = await retornaFiltros();
        const bImprimeAutomatico = await verificaImprimirAutomatico('RelBordero');
        const arquivo = await GeraRelatorio(`${url}${filtros}&`, 'GET', 10000, false, 'RelBordero');
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          }
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });
});